// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-1: Introduction
//Example: 1.6  Page 18
// Title: Total Heat Loss by Convection and Radiation
//===================================================================
model Ex1_6

//===============
// Libraries 
extends Modelica.Constants;

//=============
// Variable Section
Real q_by_L_tot(unit= "W/m")"Total heat loss per unit length";
Real q_by_L_conv(unit= "W/m")"Convection heat loss per unit length";
Real q_by_L_rad(unit= "W/m")"Radiation heat loss per unit length";  

//=============
// Parameter Section
parameter Real d(unit ="cm") = 5"Diameter of steel pipe";
parameter Real T_w(unit ="C")=50"Temperature of the steel pipe";
parameter Real T_infinity(unit ="C") = 20"Temperature of the air";
parameter Real ephsilon = 0.8"Surface Emissivity";


//Note : Value of "h" obtained from Table :1-3 (Page : 11)
parameter Real h(unit ="W/m^2.C")= 6.5"Heat transfer coefficient for free convection";

//=============
// Equation Section
equation
q_by_L_conv = h *(pi * d*0.01)*(T_w - T_infinity);//Calculation of convection heat loss
//Note : Multiplication by 0.01 to convert d to m from cm
q_by_L_rad = ephsilon * (pi * d*0.01)*sigma*((T_w+273)^4 -(T_infinity+273)^4);//Calculation of radiation heat loss
//Note : Multiplication by 0.01 to convert d to m from cm  
//          Addition of 273 to T_w and T_infinity to convert temperature scale to Kelvin.
//          sigma is the Stefan Boltzman Constant 

q_by_L_tot = q_by_L_conv + q_by_L_rad;//Calculation of total heat loss

end Ex1_6;
//===================================================================
