// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.14 Page 553
// Title: Ammonia Condenser
//===================================================================
model Ex10_14
//=============
// Variable Section 
Real mw(unit="kg/s")"Mass flow rate of water";

Real Cmin"Capacity rate";

Real NTU"Number of transfer units";

Real N"Number of transfer units  when flowrate is halved ";

Real A(unit="m^2")"Area of the exchanger";

Real e_new"New effectiveness factor";

Real delta_Tw(unit="C")"New temperature difference";

Real q_new(unit="kW")"New heat transfer rate";
//=============
// Parameter Section 
parameter Real Ta_in(unit="C")=50"Inlet temperature of ammonia vapour";

parameter Real Tw_in(unit="C")=20"Inlet temperature of water";
parameter Real Tw_out(unit="C")=40"Outlet temperature of water";

parameter Real c_w(unit="kJ/kg.C")=4.18"Specific heat of water";

parameter Real q(unit="kW")=200"Heat transfer required";

parameter Real U(unit="W/m^2.C")=1000"Overall heat transfer coefficient obtained from Table 10.1";
parameter Real e=0.6"Heat exchanger Effectiveness";

//=============
// Equation Section 

equation
//Calculation of mass flow rate of water
mw = (q/(c_w*(Tw_out - Tw_in)));

//Calculation of Cmin
Cmin = mw*c_w;

//Calculation of Number of Transfer units
NTU = -log(1-e);

//Heat Exchanger area
A = (Cmin*1000 *(NTU/U));

//Case when flow rate of water is halved

N = (U*A)/((Cmin*1000)/2);

//New effectiveness factor
e_new = (1-(exp(-N)));

//New water temperature difference
delta_Tw = e_new *(Ta_in - Tw_in);

//Calculation of new heat transfer rate
q_new = (Cmin/2) *delta_Tw;

end Ex10_14;
//======================================================================== 
