// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-2: Steady-state Conduction-One Dimesnsion
//Example: 2.1 Page 31
// Title: Multilayer Conduction
//===================================================================
model Ex2_1

//=============
// Variable Section 
Real deltax_rw(unit = "m")"Thickness of the rock-wool insulation";
Real Rb(unit="m^2.C/W")"Thermal Resistance of common brick";
Real Rp(unit="m^2.C/W")"Thermal Resistance of gypsum plaster";
Real R_without_insulation(unit="m^2.C/W")"Overall Thermal Resistance without insulation";
Real R_insulation(unit="m^2.C/W")"Overall Thermal Resistance with insulation";
Real R_rw(unit="m^2.C/W")"Thermal Resistance of rock-wool";

//=============
//Parameter Section
parameter Real kb(unit="W/m.C")=0.7"Thermal conductivity of common brick";
parameter Real deltax_b(unit = "inch")=4"Thickness of common brick";
parameter Real kp(unit="W/m.C")=0.48"Thermal conductivity of gypsum plaster";
parameter Real deltax_p(unit = "inch")=1.5"Thickness of gypsum plaster";
parameter Real k_rw(unit="W/m.C")=0.065"Thermal conductivity of  rock wool insulation";

//==============
equation
Rb = (deltax_b*2.54*0.01)/kb;//Calculation of thermal resistance
 // * Note: Multiplication by 2.54*0.01 to convert from inch to m
 
Rp = (deltax_p*2.54*0.01)/kp;
// * Note: Multiplication by 2.54*0.01 to convert from inch to m
R_without_insulation = Rb+ Rp;

//Division by 0.2 to consider the reduction in heat loss 
R_insulation = (R_without_insulation)/0.2;

R_insulation = Rb + Rp + R_rw;

deltax_rw = R_rw * k_rw;//Calculation of the thickness of the rock wool insulation

end Ex2_1;
//========================================================================
