// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-2: Steady State Conduction : One Dimension
//Example: 2.10 Page 55
//Title: Circumferential Aluminium Fin
//===================================================================
model Ex2_10
//=============
// Variable Section

Real q_act(unit = "W")"Actual heat transfer rate";
Real q_max(unit = "W")"Maximum heat transfer rate";
Real Lc(unit = "cm")"Corrected Length";
Real r1(unit = "cm")"Radius of the tube";
Real r2c(unit ="cm")"Corrected Radius";
Real Am(unit = "m^2")"Profile area";
Real Lc_1;

//=============
// Parameter Section 
parameter Real t(unit ="mm")=1"Thickness of the fin";
parameter Real L(unit = "cm") =1.5"Length of the fin";
parameter Real d(unit = "cm")=2.5"Tube diameter";
parameter Real h(unit = "W/m^2.C")=130"Convectional heat transfer coefficient";     
parameter Real k(unit = "W/m.C")=200"Thermal conductivity of aluminium";
parameter Real T_surface(unit ="C")=170"Surface temperature";
parameter Real T_ambient(unit = "C")= 25"Ambient fluid temperature";
parameter Real F_efficiency=0.82;   // Figure 2.12 :Page 50 :Graph of Fin efficiency vs ((Lc^1.5)*(h/kAm)^0.5)

//=============
// Equation Section 

equation

//Corrected fin length
Lc = L + ((t*0.1)/2);
r1 = d/2;
r2c = r1 + Lc;

Am = (t*0.001)*(r2c-r1)*0.01;
Lc_1= ((Lc^1.5)*(h/(k*Am))^0.5);

//Heat transferred if entire fin is at base temperature
q_max = 2*3.14*(r2c^2- r1^2)*0.0001*h*(T_surface-T_ambient);

//Actual heat transfer
q_act = q_max * F_efficiency;


end Ex2_10;
//===================================================================
