 // Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-2: Steady-state Conduction-One Dimesnsion
//Example: 2.3 Page 36
// Title: Heat transfer through a composite wall
// Note : Problem data refered to Figure:Example2.3(Page 36)
//===================================================================
model Ex2_3
//=============
// Variable Section 
//Induvidual Thermal Resistances 
Real R_air(unit="C/W")"Thermal Resistance of air";
Real R_b(unit="C/W")"Thermal Resistance of brick";
Real R_os(unit="C/W")"Thermal Resistance of outer sheath";
Real R_ws(unit="C/W")"Thermal Resistance of wodden stud";
Real R_is(unit="C/W")"Thermal Resistance of inner sheath";
Real R_i(unit="C/W")"Thermal Resistance of insulation";
Real R_tot(unit="C/W")"Total Thermal Resistance ";
Real A(unit="m^2")"Area of heat transfer";
//=============
Real A1(unit="m^2");
Real R_ins(unit="C/W")"Conduction Resistance through insulation section";
Real R_total(unit="C/W")"Total Resistance through insulation section";
Real R_overall(unit="C/W")"Overall Resistance";
Real U(unit="W/m^2.C")"Overall heat transfer coefficient";
Real R_value(unit="C.m^2/W");

//=============
// Parameter Section 
parameter Real l(unit="cm") = 4.13"Length of wood studs";
parameter Real b(unit="cm")= 1"Unit Depth";
parameter Real hi(unit="W/m^2.C")=7.5"Convectional Inside heat transfer coefficient";
parameter Real ho(unit="W/m^2.C")=15"Convectional Outside heat transfer coefficient";
parameter Real k_b(unit="W/m.C")=0.69"Thermal Conductivity of brick";
parameter Real k_gi(unit="W/m.C")=0.96"Thermal Conductivity of gypsum inner sheath";
parameter Real k_ws(unit="W/m.C")=0.1"Thermal Conductivity of wood stud";
parameter Real k_go(unit="W/m.C")=0.48"Thermal Conductivity of gypsum outer sheath";
parameter Real deltax_b(unit="m") =0.08"Thickness of brick";
parameter Real deltax_os(unit="m")=0.019"Thickness of outer sheath";
parameter Real deltax_is(unit="m")=0.019"Thickness of inner sheath";
parameter Real deltax_ws(unit="m")=0.0921"Thickness of wodden stud";
//=================
parameter Real deltax_ins(unit="m")=0.0921"Thickness of insulation";
parameter Real k_ins(unit="W/m.C") = 0.04"Thermal Conductivity of Insulation";

equation
A = (l*0.01) * b;
//Calculation of induvidual thermal resistances
R_air = 1/(ho *  A);
R_b = deltax_b/(k_b * A);
R_os = deltax_os/(k_gi * A);
R_ws =deltax_ws/(k_ws * A);
R_is = deltax_is/(k_go * A);
R_i = 1/(hi * A);
R_tot = R_air +R_b + R_os + R_ws +R_is+R_i;
//==================
A1 = 0.406-A;

//Calculation of conduction resistance through insulation section
R_ins = deltax_ins/(A1 * k_ins);
R_total = ((R_air+R_b+R_os+R_is+R_i)* 0.113)+R_ins;
R_overall =1/((1/R_tot) + (1/R_total)); 

//Calculation of overall heat transfer coefficient
U = 1/(R_overall * 0.406);

R_value = 1/U;

end Ex2_3;
//========================================================================


