// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-2: Steady State Conduction : One Dimension
//Example: 2.6 Page 40
// Title: Critical Insulation Thickness
//===================================================================
model Ex2_6

//=============
// Variable Section 
Real r(unit = "m")"Radius of the pipe";
Real ro(unit = "m")"Critical Radius of Insulation";
Real ro_fibreglass(unit = "m")"Critical Radius of Insulation with fibre glass as insulation";
Real q_L(unit = "W/m")"Heat transfer per unit length with insulation";
Real q_Lwins(unit = "W/m")"Heat transfer per unit length without insulation";

//=============
// Parameter Section 
parameter Real k(unit = "W/m.C") = 0.17"Thermal Conductivity of the material";
parameter Real k_fibreglass(unit = "W/m.C") = 0.04"Thermal Conductivity of the fibre glass material";
parameter Real To(unit = "C")=20"Temperature of room air";
parameter Real Ti(unit = "C")=200"Inside Temperature ";
parameter Real h(unit = "W/m^2.C")=3"Heat transfer Coefficient";
parameter Real dia(unit = "cm")=5"Diameter of the pipe";

equation
r = 0.5 * dia *0.01;
//Note : Multiplication of dia by 0.01 to convert to m from cm
ro = k/h;
//Calculation of q/L with insulation 
q_L = ((2*3.14*(Ti-To))/((log(ro/r)/k) + 1/(h*ro)));

//Calculation of q/L without insulation
q_Lwins = h *2*3.14 *r*(Ti-To);

//Calculation of critical radius when fibre glass is employed as an insulation
ro_fibreglass = k_fibreglass/h;
end Ex2_6;
//===================================================================
