// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-2: Steady State Conduction : One Dimension
//Example: 2.9 Page 55
//Title: Straight Aluminium Fin
//===================================================================
model Ex2_9

//=============
// Variable Section 
Real q(unit = "W/m")"Heat loss from the fin";
Real m;
Real A(unit = "m^2")"Cross sectional area of the fin";
Real Lc(unit = "cm")"Corrected Length";

//=============
// Parameter Section 
parameter Real k(unit = "W/m.C")=200"Thermal conductivity of the fin";
parameter Real t(unit = "mm")=3"Thickness of the fin";
parameter Real L(unit = "cm")=7.5"Length of the fin";
parameter Real h(unit = "W/m^2.C")=10"Convectional Heat transfer coefficient";
parameter Real T_base(unit = "C") = 300"Base temperature";
parameter Real T_ambient(unit = "C")=50"Ambient temperature";

//=============
// Equation Section 
equation
Lc = L + ((t*0.1)/2);//Calculation of corrected length
//Note : Multiplication of t by 0.1 to convert to cm

m = sqrt((2*h)/(k*t*0.001));
//Note : Multiplication of t by 0.001 to convert t from mm to m

A = 1*(t*0.001);

q = m*k*(t*0.001)*(T_base - T_ambient)*tanh(m*(Lc*0.01));
//Note : Multiplication of Lc by 0.01 to covert from cm to m

end Ex2_9;
//===================================================================
