// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-3: Steady-State Conduction: Multiple Dimension 
//Example: 3.1 Page 87
// Title: Buried Pipe
//===================================================================
model Ex3_1
extends Modelica.Math;
//=============
// Variable Section 
Real q(unit = "W")"Heat lost  by the pipe";
Real r(unit ="cm")"Radius of pipe";
Real S(unit = "m")"Shape Factor";
Real delta_T(unit = "C")"Temperature Difference";

//=============
// Parameter Section 
parameter Real d(unit ="cm") = 15"Diameter of the pipe";
parameter Real L(unit ="m")  =4"Length of the pipe";
parameter Real D(unit ="cm") = 20"Depth of the pipe inside Earth";
parameter Real T_wall(unit = "C") = 75"Wall temperature";
parameter Real T_surface(unit = "C") = 5"Earth surfacetemperature";
parameter Real k(unit = "W/m.C")=0.8"Thermal conductivity of Earth";

//=============
// Equation Section 
equation
r = d/2;
delta_T = T_wall - T_surface;//Temperature Difference 
S = ((2*3.14*L)/(acosh(D/r)));//Shape Factor
q = k*delta_T*S;//Calculation of Heat lost by the pipe

end Ex3_1;
//===================================================================
