// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-3: Steady-State Conduction: Multiple Dimension 
//Example: 3.2 Page 87
// Title: Cubical Furnace
//===================================================================
model Ex3_2
//=============
// Variable Section 
Real S(unit = "m")"Total Shape Factor";
Real q(unit = "kW")"Heat lost  through the walls";
Real delta_T(unit = "C")"Temperature Difference";
Real S1,S2,S3;

//=============
// Parameter Section 
parameter Real a(unit = "cm")=50"Length of side of cubical furnace";
parameter Real L(unit = "cm") =10"Wall thickness";
parameter Real T_inside(unit = "C")=500"Inside furnace temperature";
parameter Real T_outside(unit = "C")=50"Outside furnace temperature";
parameter Real k(unit = "W/m.C")=1.04"Thermal conductivity of  Fireclay brick";

//=============
// Equation Section 
equation

delta_T = (T_inside-T_outside);
//Calculation of induvidual shape factors
//Multiplication of a and L by 0.01 to convert to m from cm

S1 = (a*a*0.01*0.01)/(L*0.01);
S2= (0.54*a*0.01);
S3 =(0.15*L*0.01);

//There are 6 wall sections, 12 edges and 8 corners
S = (S1*6)+(S2*12)+(S3*8);

q = k*S*delta_T*0.001;//Calculation of heat lost through the walls
//Multiplication of q by 0.001 to represent the heat loss in kW

end Ex3_2;

//===================================================================
