// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-3: Steady-State Conduction: Multiple Dimension 
//Example: 3.3 Page 87
// Title: Buried Disk
//===================================================================
model Ex3_3
//Libraries
extends Modelica.Constants;

//=============
// Variable Section 

Real S"Shape factor for the desired geometry";
Real r(unit="m")"Radius of the disk";

Real q(unit="W")"Heat transfer rate";
//=============
// Parameter Section 
parameter Real d(unit="cm")=30"Diameter of the disk";
parameter Real T_object(unit="C")=95"Temperature of the disk";
parameter Real h(unit="m") = 1"Depthe at which the disc is burried in semi infinite medium";
parameter Real T_farfield(unit="C")=20"Temperature of the isothermal surface";
parameter Real k(unit="W/m.K")=2.1"Thermal conductivity of the surface";

//=============
// Equation Section 
//Table 3.1 is consulted for solving the below Example
equation
r = (d*0.01)/2;

//Calculation of Shape Factor
S = (4*pi*r)/((pi/2) -  atan(r/2));

//Calculation of heat transfer rate
q = k*S*(T_object - T_farfield);

end Ex3_3;
//=============================================================
