// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.2 Page 146
// Title:  Semi-Infinite Solid with Sudden Change in Surface Conditions
//===================================================================
model Ex4_2
extends Modelica.Math;
//=============
// Variable Section
Real T_a(unit = "C")"Temperature of the solid at 250 C";
Real T_b(unit = "C")"Temperature at constant heat flux condition";
Real T_c(unit = "C")"Temperature at the surface when x=0";
Real erf "Error function";
//=============
// Parameter Section
parameter Real k(unit = "W/m.C") =45"Thermal conductivity of the steel block";
parameter Real alpha(unit= "m^2/s") = 1.4E-5"Thermal diffusivity of the steel block";
parameter Real Ti(unit ="C")=35"Initial temperature of the steel block";
parameter Real To(unit ="C")=250"Final temperature of the steel block";
parameter Real qo_A(unit ="W/m^2")=3.2E5"Constant surface heat flux";
parameter Real x(unit="cm")=2.5"Depth at which temperature is computed";
parameter Real tow(unit="min")=0.5"Time after which temperature is calculated";
parameter Real erfun_erf= 0.61164"Error function value obtained from Appendix-A Page:649";

//=============
// Equation Section
equation
erf =     (x*0.01)/(2*sqrt(alpha*tow*60));
//Note: Multiplication of tow by 60 to convert to s from min

//Transient Heat Flow Equations in Semi-Infinite Solid
T_a = To + (Ti - To)*erfun_erf;
T_b -Ti = 2*(qo_A)*(1/k)*sqrt((alpha*tow*60)/3.14)*exp(-(erf^2)) - (x*0.01*qo_A *(1/k))*(1-erf);
//Note : Multiplication of x by 0.01 to convert to m from cm


//Temperature at the surface when x=0
T_c = Ti + 2*(qo_A)*(1/k)*sqrt((alpha*tow*60)/3.14) ;

end Ex4_2;
//=========================================================================
