// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.6 Page 160
// Title:  Aluminum Plate Suddenly Exposed to Convection
//===================================================================
//Note : The below problem is linked to the convection environment in Example 4.5
model Ex4_6

//=============
//Variable Section
Real T(unit ="C")"Temperature at a depth of 1.25cm from one of the faces after 1min exposure to plate environment";
Real Q_A(unit ="J/m^2")"Heat removed per unit surface area";
Real Qo_A;

Real theta_i;
Real theta_o;
Real theta;
Real x(unit="cm")"Depth at which temperature is computed";
Real X_L;
Real A,X,V,B;

//=============
//Parameter Section

parameter Real alpha(unit = "m^2/s")= 8.4E-5"Thermal Diffusivity of Aluminium";
parameter Real tow(unit="s")=60"Time after which the plate has been exposed to the environment";
parameter Real k(unit = "W/m.C")= 215"Thermal Conductivity of Aluminium";
parameter Real h(unit="W/m^2.K")=525"Heat Transfer Coefficient of the covection environment";
parameter Real Ti(unit = "C")= 200"Initial Temperature of the slab";
parameter Real T_infinity(unit = "C")= 70"Final Temperature of the slab";
parameter Real L(unit="cm")= 5"Thickness of the plate";
parameter Real xo(unit="cm")=1.25"Value of Depth from one of the faces ";
parameter Real rho(unit="kg/m^3")=2700"Density of Aluminium";
parameter Real c(unit="kJ/kg.C")=0.9"Specific Heat of Aluminium";

//The below values are obtained from specified references
parameter Real theta_o_by_theta_i=0.61"Value obtained from Figure:4.7(Page:144-145) ";
parameter Real theta_by_theta_o = 0.98"Value obtained from Figure:4.10(Page:149) at x/L =0.5 ";
parameter Real Q_by_Qo = 0.41"Value obtained from Figure:4.14(Page:152) ";

//=============
//Equation Section
equation
//Calculation of depth at which the temperature is computed
x = ((L/2)-xo);
//Note : Multiplication of L by 0.5 to calculate the original thickness of the plate

theta_i= (Ti-T_infinity);

//Note : Multiplication of L by 0.5 to calculate the original thickness of the plate
//Note : Multiplication of L by 0.01 to covert the units to m from cm
A = (alpha*tow)/(0.5*L*0.01*0.5*L*0.01);
X = k/(h*0.5*L*0.01);
X_L = (x)/(0.5*L*0.01);
 
//Calculation of Temperature at a depth of 1.25cm from one of the faces after 1min exposure to plate environment
theta_o = theta_o_by_theta_i * theta_i;
theta = theta_by_theta_o*theta_o;
T = T_infinity + theta;

//Note : We use Figure 4.14 (Page No:152)
//The properties of alumnium are defined as parameters 

V =( (h^2)*alpha*tow)/(k^2) ;
B = (h*(L*0.5)*0.01)/k;
//Note : Multiplication of L by 0.5 to calculate the original thickness of the plate
//Note : Multiplication of c by 1000 to convert the units from kJ to J 
Qo_A =(rho*c*1000*2*(L/2)*0.01*theta_i);
//Calculation of heat removed per unit surface area
Q_A = Qo_A*Q_by_Qo ;


end Ex4_6;
//=======================================================================
