// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.7 Page 161
// Title: Long Cylinder Suddenly Exposed to Convection
//===================================================================
model Ex4_7

//=============
//Variable Section
Real T(unit ="C")"Temperature at a radius of 1.25cm";
Real Q_L(unit ="J/m")"Heat lost per unit length";
Real Qo_L;

Real theta_i;
Real theta_o;
Real theta;
Real ro(unit="cm")" Radius of the aluminium cylinder";
Real r_by_ro;
Real A,X,V,B;

//=============
//Parameter Section
parameter Real alpha(unit = "m^2/s")= 8.4E-5"Thermal Diffusivity of Aluminium";
parameter Real tow(unit="s")=60"Time after which the plate has been exposed to the environment";
parameter Real k(unit = "W/m.C")= 215"Thermal Conductivity of Aluminium";
parameter Real h(unit="W/m^2.K")=525"Heat Transfer Coefficient of the covection environment";
parameter Real Ti(unit = "C")= 200"Initial Temperature of the slab";
parameter Real T_infinity(unit = "C")= 70"Final Temperature of the slab";
parameter Real r(unit="cm")= 1.25" Radius at which temperature is calculated";
parameter Real d(unit="cm")=5" Diameter of the cylinder ";
parameter Real rho(unit="kg/m^3")=2700"Density of Aluminium";
parameter Real c(unit="kJ/kg.C")=0.9"Specific Heat of Aluminium";

//The below values are obtained from specified references
parameter Real theta_o_by_theta_i=0.38"Value obtained from Figure:4.8(Page:144-145) ";
parameter Real theta_by_theta_o = 0.98"Value obtained from Figure:4.11(Page:149) at x/L =0.5 ";
parameter Real Q_by_Qo = 0.65"Value obtained from Figure:4.15(Page:152) ";

//=============
//Equation Section
equation
//Calculation of  radius of the cylinder
ro = d/2;
theta_i= (Ti-T_infinity);

//Note : Multiplication of L by 0.01 to covert the units to m from cm
A = (alpha*tow)/((ro*0.01)^2);
X = k/(h*ro*0.01);
r_by_ro = (r)/(ro);
 
//Calculation of Temperature at a  radius of 1.25 cm 
theta_o = theta_o_by_theta_i * theta_i;
theta = theta_by_theta_o*theta_o;
T = T_infinity + theta;

//Note : We use Figure 4.15 (Page No:152)
//The properties of alumnium are defined as parameters 

V =( (h^2)*alpha*tow)/(k^2) ;
B = (h*(ro)*0.01)/k;

//Note : Multiplication of c by 1000 to convert the units from kJ to J 
Qo_L =(rho*c*1000*3.14*(ro*0.01)^2*theta_i);

//Calculation of heat lost per unit length
Q_L = Qo_L*Q_by_Qo ;


end Ex4_7;
//========================================================================
