// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.1 Page 220
// Title: Water flow in a Diffuser
//===================================================================
model Ex5_1

//=============
// Variable Section
Real A1(unit="m^2")"Cross sectional area at Section-1";
Real A2(unit="m^2")"Cross sectional area at Section-2";
Real u1(unit="m/s")" Velocity at Section-1";
Real u2(unit="m/s")" Velocity at Section-2";
Real p2_p1(unit ="kPa")"Static Pressure Difference";
//=============
// Parameter Section
parameter Real Tin(unit="C")=20"Inlet temperature of water";
parameter Real m_in(unit ="kg/s")=8"Mass flow rate of water";
parameter Real d1(unit="cm")=3"Diameter at section-1";
parameter Real d2(unit="cm")=7"Diameter at section-2";
parameter Real rho(unit="kg/m^3")=1000"Density of water at 20 C";


//=============
// Equation Section
equation
//Calculation of cross sectional area at section1 and section 2
//Note :Multiplication by 0.01 to convert unit of d from cm to m 
A1 = (3.14*d1*0.01*d1*0.01)/4;
A2 = (3.14*d2*0.01*d2*0.01)/4;

//Calculation of velocities at the respective sections
u1 = (m_in)/(rho*A1);
u2 = (m_in)/(rho*A2);

//Calculation of Static Pressure Difference between the 2 sections
//Note : Multiplication by 1E-3 to convert the units of p2_p1 to kPa from Pa
(p2_p1) = ((rho/2)*((u1^2)-(u2^2)))*1E-3;

end Ex5_1;

//========================================================================
