// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.11 Page 261
// Title: High-Speed Heat Transfer for a Flat Plate
//===================================================================
model Ex5_11
//=============
// Variable Section
Real a(unit="m/s")"Accoustic velocity";
Real rho_infinity(unit="kg/m^3")"Density at free stream conditions";
Real rho_star(unit="kg/m^3")"Density at reference conditions";
Real u_infinity(unit="m/s")"Free stream velocity";
Real Re_L"Reynolds Number";

Real To(unit="C")"Stagnation temperature";

Real Taw(unit="C")"Adiabatic wall temperature";
Real r"Recovery factor";
Real T_star(unit="C")"Reference temperature";
Real Nu_star"Nusselt Number at Lamib]nar conditions";
Real x_c(unit="m")"Boundary layer thickness";
Real q(unit="W")"Heat transfer rate in Laminar region";
Real h_bar(unit="W/m^2.C")"Heat transfer coefficient-Laminar region";

//Turbulent conditions
Real r_turbulent"Recovery factor";
Real Taw_turbulent(unit="C")"Adiabatic wall temperature-Turbulent conditions";
Real T_star_turbulent(unit="C")"Reference temperature";
Real rho_star_turbulent(unit="kg/m^3")"Density at reference conditions";
Real h_x(unit="W/m^2.C")"Heat transfer coefficient-Turbulent region";
Real q_turbulent(unit="W")"Heat transfer rate in Turbulent region";

Real q_total(unit="W")"Total Heat transfer rate";
//=============
// Parameter Section
parameter Real L(unit="cm")=70"Length of the flat plate";
parameter Real W(unit="m")=1"Width of the flat plate";

parameter Real M_infinity =3"Mach Number";
parameter Real R(unit="J/kg.K")=287"Gas constant";
parameter Real P(unit="atm") =1/20"Pressure of wind";
parameter Real gamma=1.4;
parameter Real Pr=0.7"Prandtl number";

parameter Real T_infinity(unit="C")=-40"Temperature of the wind";
parameter Real mu_infinity(unit="kg/m.s")=1.434E-5"Viscocity at free stream conditons";

parameter Real x_i(unit="m")=0.7;
parameter Real x_o(unit="m")=0.222;

//Properties obtained at reference temperature
parameter Real mu_star(unit="kg/m.s")=2.07E-5"Viscocity at the reference temperature";
parameter Real Pr_star=0.7"Prandtl number obtained at the reference temperature";
parameter Real k_star(unit="W/m.C")=0.03"Thermal conductivity obtained at reference temperature";
parameter Real c_pstar(unit="kJ/kg.C")=1.009"Specific heat at reference temperature";
parameter Real T_w(unit="C")=35"Temperature at which plate is to be maintained";
parameter Real Re_critical=5E5"Reynolds Number";

//Turbulent conditions
parameter Real Pr_star_turbulent=0.695"Prandtl number obtained at the reference temperature";
parameter Real k_star_turbulent(unit="W/m.C")=0.0302"Thermal conductivity obtained at reference temperature";
parameter Real c_pstar_turbulent(unit="kJ/kg.C")=1.009"Specific heat at reference temperature";
parameter Real mu_star_turbulent(unit="kg/m.s")=2.09E-5"Viscocity at the reference temperature";

//=============
// Equation Section
equation

//Calculation of accoustic velocity
a = sqrt(R*(T_infinity+273)*gamma);

//Calculation of free stream velocity
u_infinity = a*M_infinity;

//Calculation of Density
rho_infinity =( (1.01325*1E5)*(P))/(R*(T_infinity+273));

//Calculation of maximum Reynolds Number
Re_L =(u_infinity*rho_infinity*L*0.01)/(mu_infinity);

//Laminar Portion Calculations

//Calculation of stagnation temperature
To = (T_infinity+273) *(1+(((gamma-1)/2)*(M_infinity^2)));

//Calculation of recovery factor
r = (Pr)^0.5;

//Calculation of adiabatic wall temperature
r = (Taw- (T_infinity+273))/(To-(T_infinity+273));

//Calculation of reference temperature
T_star= (T_infinity+273) +(0.5*((T_w+273) - (T_infinity+273)))+(0.22*(Taw-(T_infinity+273)));

//Corrected Properties at reference temperature
rho_star=( (1.01325*1E5)*(P))/(R*(T_star));

//Laminar Heat Transfer
Re_critical = (rho_star*u_infinity*x_c)/(mu_star);

//Nusselt number for lamibar flow
Nu_star =0.664*(Re_critical)^0.5*(Pr_star)^(1/3);

//Calculation of heat transfer coefficient
h_bar = (Nu_star *k_star)/(x_c);

//Heat transfer rate-Laminar region
q = h_bar *x_c*((T_w+273) - Taw);

//===========================
//Turbulent Portion Calculations
r_turbulent = (Pr)^(1/3);

//Calculation of adiabatic wall temperature
r_turbulent = (Taw_turbulent- (T_infinity+273))/(To-(T_infinity+273));

//Calculation of reference temperature
T_star_turbulent= (T_infinity+273) +(0.5*((T_w+273) - (T_infinity+273)))+(0.22*(Taw_turbulent-(T_infinity+273)));

//Corrected Properties at reference temperature
rho_star_turbulent=( (1.01325*1E5)*(P))/(R*(T_star_turbulent));


//Calculation of heat transfer coefficient
//Simplified Integrated Expression
h_x = (((94.34*(5/4))*((x_i^(4/5))-x_o^(4/5)))/(x_i-x_o));

//Heat transfer rate-Laminar region
q_turbulent = h_x *(x_i-x_o)*((T_w+273) - Taw_turbulent);

//Total cooling
q_total = (-q) + (-q_turbulent);

end Ex5_11;
//=====================================================================
