// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.2 Page 221
// Title: Isentropic Expansion of Air
//===================================================================
model Ex5_2

//=============
// Variable Section
Real T2(unit = "C")"Static Temperature";
Real p2(unit = "Mpa")"Static Pressure";
Real a2(unit="m/s")"Velocity of sound at condition 2";
Real M2"Mach Number";

//=============
// Parameter Section
parameter Real T1(unit="C")=300"Temperature of Air";
parameter Real p1(unit="MPa")=0.7"Pressure of Air";
parameter Real u2(unit="m/s")=300" Velocity upto which air is expanded isoentropically";
parameter Real gamma=1.4"Gamma value of air";
parameter Real Cp(unit="J/kg.C")=1005" Specifi Heat";

//=============
// Equation Section
equation
//Calculation of Static Temperature
Cp*(T1-T2) = ((u2)^2)/(2);

//Calculation of Static Pressure
(p2/p1) = ((T2+273)/(T1+273))^((gamma)/(gamma-1));

//Calculation of velocity of sound at condition 2
a2 = (20.045)*((T2+273)^0.5);

//Mach Number
M2 = u2/a2;

end Ex5_2;

//========================================================================
