// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.9 Page 249
// Title: Turbulent Heat Transfer from Isothermal Flat Plate
//===================================================================
model Ex5_9

//=============
// Variable Section
Real Tf(unit="C")"Film temperature";
Real rho(unit="kg/m^3")"Density of air";

Real Re_L"Reynolds number";
Real Nu_L"Nusselt number";
Real h_bar(unit="W/m^2.C")"Heat transfer coefficient";

Real q(unit="W")"Heat transfer rate";
//=============
// Parameter Section
parameter Real T_infinity(unit="C")=20"Inlet temperature of air";
parameter Real P(unit="atm")=1"Inlet pressure of air"; 

parameter Real u_infinity(unit="m/s")=35"Velocity at which air flows in";
parameter Real L(unit="cm")=75"Length of the plate";

parameter Real R(unit="J/kg.K")=287"Gas constant";
parameter Real T_w(unit="C")=60"Plate temperature";

//Properties at film temperature
parameter Real mu(unit="kg/m.s")=1.906E-5"Viscocity of air at film temperature";
parameter Real Pr= 0.7"Prandtl number";
parameter Real k(unit="W/m.C")=0.02723"Thermal conductivity at film temperature";
parameter Real c_p(unit="kJ/kg.C")=1.007"Specific heat at film temperature";

//=============
// Equation Section
equation
//Calculation of film temperature
Tf = (T_w +T_infinity)/2;

//Calculation of density at film temperature
rho = (P*1.0132*1E5)/(R*(Tf+273));

//Calculation of Reynolds number
Re_L = (rho*u_infinity*L*0.01)/(mu);

//Calculation of Nusselt Number
Nu_L =( (Pr)^(1/3) *((0.037*(Re_L)^0.8) - 871));

//Calculation of heat transfer coefficient
h_bar = Nu_L *(k/(L*0.01));

//Calculation of heat transfer rate
q = h_bar * (L*0.01)*(T_w - T_infinity);

end Ex5_9;
//========================================================================
