// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.2 Page 288
// Title: Heating ofWater in Laminar Tube Flow
//===================================================================

model Ex6_2
//=============
// Variable Section
Real h(unit="W/m^2.C")"Heat Transfer Coefficient";
Real m(unit="kg/s")"Mass Flow Rate";
Real Red"Reynolds Number";
Real Nud"Nusselt Number";
Real Tb2(unit="C")"Exit Bulk Temperature";
Real Tb_mean(unit="C")"Mean Bulk temperature";
Real Parameter"Parameter to check the applicablity of heat transfer equation";
//=============
// Parameter Section
parameter Real Tb1(unit="C")=60"Bulk Temperature";
parameter Real Tw(unit="C")=80"Constant wall temperature";
parameter Real um(unit="cm/s")=2"Mean Flow velocity";
parameter Real L(unit="m")=3"Length of the tube";
parameter Real d(unit="inch")=1"Diameter of the tube";

parameter Real mu_w(unit="kg/m.s")=3.55E-4"Dynamic viscocity at wall temperature";

//Properties at Bulk Temperature
parameter Real rho(unit="kg/m^3")=985"Density of water at bulk temperature";
parameter Real mu(unit="kg/m.s")=4.71E-4"Dynamic viscocity at bulk temperature";
parameter Real Pr=3.02"Prandtl Number";
parameter Real k(unit="W/m.C")=0.651"Thermal conductiviy at bulk temperature";
parameter Real Cp(unit="kJ/kg.C")=4.18"Specific heat";

// Equation Section
equation
//Calculation of Reynolds Number
Red = (rho*um*0.01*(d*0.0254))/(mu);

//Calculation of Nusselt Number using Laminar Flow correlation
//Parameter to check the applicablity of the equation
Parameter= Red*Pr*((d*0.0254)/L);
Nud=1.86*((((Red)*(Pr)*(d*0.0254))/L)^0.333)*((mu/mu_w)^0.14);

//Calculation of heat transfer coefficient
h = Nud *(k/(d*0.0254));

//Mass Flow Rate
m =( rho *um*0.01* 3.14*(d*0.0254)^2)/(4);
//Calculation of exit bulk mean temperature
h*3.14*(d*0.0254)*L*(Tw -( (Tb1+Tb2)/2)) = m*Cp*1000*(Tb2-Tb1);

//Calculation of bulk mean temperature
Tb_mean = (Tb1+Tb2)/2;
end Ex6_2;
//========================================================================
