// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.4  Page 290
// Title: Heating of Air with Isothermal TubeWall
//===================================================================
//Note: The below example is a repetition of Example 6.3 for constant wall temperature
//          The results of the previous example are considered as parameters here
model Ex6_4
//=============
// Variable Section
Real h_bar(unit="W/m^2.C")"Average Heat Transfer Coefficient";
Real Tw(unit="C")"Wall temperature";
Real Tw_Tb_bar(unit="C")"Temperature Difference";
//=============
// Parameter Section
parameter Real Nud=5.15"Nusselt number value for constant wall temperature";
parameter Real Tb_bar(unit="C")=52"Mean Bulk Temperature";

//Parameters obtained from previous example
parameter Real k(unit="W/m.C")=0.02814"Thermal conductiviy at bulk temperature";
parameter Real d(unit="mm")=5"Diameter of the tube";
parameter Real Gr_inverse = 0.0346"Inverse of Graetz number obtained from previous example";
parameter Real q(unit="W")=3.49"Heat Transfer Rate obtained from previous example";
parameter Real L(unit="m")=0.10"Tube Length";


//=============
// Equation Section
equation
//Calculation of heat transfer coefficient
h_bar = Nud*(k/(d*0.001));
//Calculation of Temperature difference between wall and bulk temperatures
q = h_bar*3.14*d*0.001*L*(Tw_Tb_bar);
//Calculation of wall temperature
Tw = (Tw_Tb_bar)+Tb_bar;

end Ex6_4;
//==============================================================================
