// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.6  Page 292
// Title: Heat Transfer in a Rough Tube
//===================================================================
model Ex6_6
//=============
// Variable Section
Real Red"Reynolds Number";
Real Nud"Nusselt Number";
Real h(unit="W/m^2.C")"Heat Transfer coefficient ";
Real h_new(unit="W/m^2.C")"Increased Heat Transfer coefficient ";
Real m(unit="kg/h")"Mass Flow Rate";
Real A(unit="m^2")"Tube Surface Area";
Real q_A(unit="W/m^2")"Heat Flux";
Real Tb_bar(unit="K")"Bulk mean temperature";
Real Tw_bar(unit="K")"Average Wall Temperature";
Real q(unit="W")"Heat Transfer Rate";

//=============
// Parameter Section
parameter Real T(unit="K")=300"Temperature at which air enters";
parameter Real d(unit="cm")=2"Diameter of the tube";
parameter Real u(unit="m/s")=40"Flow velocity";
parameter Real Nu_by_Nux=1.15"Value otained from Figure 6.6";
parameter Real delta_Tb(unit="C")=5"Average Temperature Rise";

//Properties evaluated at Bulk Mean Temperature 300K
parameter Real mu(unit="m^2/s")=15.69E-6"Kinematic viscocity at bulk temperature";
parameter Real Pr=0.7"Prandtl Number";
parameter Real k(unit="W/m.C")=0.02624"Thermal conductiviy at bulk temperature";
parameter Real rho(unit="kg/m^3")=1.18"Density of  air evaluated at the bulk temperature";
parameter Real Cp(unit="J/kg.K")=1006"Specific Heat Capacity";
parameter Real L(unit="cm")=10"Length of the tube";

//=============
// Equation Section
equation
//Calculation of Reynolds Number
Red = (u*d*0.01)/(mu);

//Calculation of Nusselt Number
Nud = 0.023*(Red)^0.8*(Pr)^0.4;

//Calculation of heat transfer coefficient
Nud = (h*d*0.01)/k;

//Increase in value of heat transfer coefficient 
h_new = h*1.15;

//Mass Flow rate 
m = (rho*u*3.14*(d*0.01)^2)/4;

//Heat Transfer Rate 
q = m*Cp*(delta_Tb);

//Tube Surface Area
A = 3.14*d*0.01*L*0.01;

//Calculation of Heat Flux
q_A = q/A;

//Calculation of bulk temperature
Tb_bar = ((T)+(T+delta_Tb))/2;

//Calculation of wall temperature
Tw_bar = Tb_bar + (q_A/h_new);

end Ex6_6;
//==============================================================
