package Ex7_1
// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.1 Page 338
// Title: Constant Heat Flux from Vertical Plate
//===================================================================
//The below problem comprises of two iterations which are performed in two seperate models.
//The values obtained from Part-1 are used as an input in Part-2

model Ex7_1_1
  extends Modelica.Math;
//=============
// Variable Section 
Real Tf(unit="C")"Film temperature";
Real beta(unit="K^-1")"Coefficient of thermal expansion";
Real Gr_x"Grashoff Number";
Real h_x(unit="W/m^2.C")"Local heat transfer coefficient";
Real delta_T(unit="C")"Temperature Difference";

 //=============
// Parameter Section 
parameter Real qw(unit="W/m^2")=800"Radiant energy flux";
parameter Real x(unit="cm")=3.5"Height of metal plate surface";
parameter Real W(unit="m")=2"Width of the metal plate";
parameter Real h(unit="W/m^2.C")=10"Heat transfer coefficient estimate for natural convection problems";
parameter Real Ta(unit="C")=30"Surrounding air temperature";
parameter Real g(unit="m/s^2")=9.81"Gravitational constant";

//Properties evaluated at film temperature
parameter Real v(unit="m^2/s")=2.043E-5"Kinematic viscocity of air at film temperature";
parameter Real k(unit="W/m.C")=0.0295"Thermal conductivity of air at film temperature";
parameter Real Pr=0.7"Prandtl Number";

 //=============
// Equation Section 
equation 
//Calculation based on assumed heat transfer coefficient of 10W/m^2
delta_T = qw/h;

//Calculation of Coefficient of thermal expansion
beta = 1/(Tf+273);

//Calculation of film temperature
Tf  = (delta_T/2) + Ta;

//Calculation of Grashoff Number
Gr_x = (g*beta*qw*(x^4))/(k*(v^2));

//Calculation of heat transfer coefficient
h_x = (k*0.17*(Gr_x*Pr)^0.25)/(x);
end Ex7_1_1;

model Ex7_1_2
  extends Modelica.Math;
//=============
// Variable Section 
Real Tf(unit="C")"Film temperature";
Real beta(unit="K^-1")"Coefficient of thermal expansion";
Real Gr_x"Grashoff Number";
Real h_x(unit="W/m^2.C")"Local heat transfer coefficient";
Real delta_T(unit="C")"Temperature Difference";
Real delta_T_new(unit="C")"New Temperature Difference";
Real Tw_avg(unit="C")"Average wall temperature";

 //=============
// Parameter Section 
parameter Real qw(unit="W/m^2")=800"Radiant energy flux";
parameter Real x(unit="cm")=3.5"Height of metal plate surface";
parameter Real W(unit="m")=2"Width of the metal plate";
parameter Real h(unit="W/m^2.C")=5.36"Heat transfer coefficient estimate obtained from Part-1";
parameter Real Ta(unit="C")=30"Surrounding air temperature";
parameter Real g(unit="m/s^2")=9.81"Gravitational constant";

//Properties evaluated at film temperature
parameter Real v(unit="m^2/s")=2.354E-5"Kinematic viscocity of air at film temperature";
parameter Real k(unit="W/m.C")=0.0320"Thermal conductivity of air at film temperature";
parameter Real Pr=0.695"Prandtl Number";

 //=============
// Equation Section 
equation 
//Calculation based on assumed heat transfer coefficient of 10W/m^2
delta_T = qw/h;

//Calculation of Coefficient of thermal expansion
beta = 1/(Tf+273);

//Calculation of film temperature
Tf  = (delta_T/2) + Ta;

//Calculation of Grashoff Number
Gr_x = (g*beta*qw*(x^4))/(k*(v^2));

//Calculation of heat transfer coefficient
h_x = (k*0.17*(Gr_x*Pr)^0.25)/(x);

//Calculation of new temperature difference
delta_T_new = qw/h_x;

//Calculation of average wall temperature
Tw_avg = delta_T_new +Ta;
end Ex7_1_2;

end Ex7_1;
