// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.5 Page 341
// Title: Heated Horizontal Pipe in Air
//===================================================================
model Ex7_5
//=============
// Variable Section

Real Tf(unit="C")"Film temperature";
Real Nu"Nusselt Number";
Real h(unit="W/m^2.C")"Heat transfer coefficient";
Real q_L(unit="kW/m")"Heat transfer per unit length";
Real Ra"Rayleigh Number";
Real beta(unit="K^-1")"Coefficient of thermal expansion";


//=============
// Parameter Section

parameter Real Tw(unit="C")=250"Wire temperature";
parameter Real T_infinity(unit="C")=15"Surrounding atmosphere temperature";
parameter Real g(unit="m/s^2")=9.81"Gravitational constant";
parameter Real d(unit="m")=0.3048"Diameter of the pipe";


//Properties evaluated at film temperature
parameter Real v(unit="m^2/s")=26.54E-6"Kinematic viscocity of air at film temperature";
parameter Real k(unit="W/m.C")=0.03406"Thermal conductivity of air at film temperature";
parameter Real Pr=0.687"Prandtl Number";


//Constants obtained from Table 7.1
parameter Real C= 0.53;
parameter Real m=0.25;


//=============
// Equation Section
equation
//Calculation of film temperature
Tf  = (Tw+ T_infinity)/2;

//Calculation of Coefficient of thermal expansion
beta = 1/(Tf+273);

//Calculation of Rayleigh Equation
Ra = (g*beta * (Tw-T_infinity)*(d)^3*Pr)/(v*v);

//Calculation of Nusselt Number
 Nu= C*((Ra)^(m));
 
//Calculation of heat transfer coefficient
 Nu= (h*d)/k;
 
 //Calculation of rate of heat transfer per unit length
 q_L = h*3.14*d*(Tw-T_infinity)*1E-3;


end Ex7_5;
//===============================================================================
