// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.6 Page 343
// Title: Cube Cooling in Air
//===================================================================
model Ex7_6
//=============
// Variable Section

Real Ra"Rayleigh Number";
Real Tf(unit="C")"Film temperature";
Real beta(unit="K^-1")"Coefficient of thermal expansion";
Real Nu"Nusselt Number";
Real h_bar(unit="W/m^2.C")"Heat transfer coefficient";
Real q(unit="W")"Heat transfer rate";

//=============
// Parameter Section

parameter Real Tw(unit="C")=60"Wire temperature";
parameter Real T_infinity(unit="C")=10"Surrounding atmosphere temperature";
parameter Real L(unit="cm")=20"Charecteristic Length";

parameter Real g(unit="m/s^2")=9.81"Gravitational constant";

//Properties evaluated at film temperature
parameter Real v(unit="m^2/s")=17.47E-6"Kinematic viscocity of air at film temperature";
parameter Real k(unit="W/m.C")=0.02685"Thermal conductivity of air at film temperature";
parameter Real Pr=0.7"Prandtl Number";


//Constants obtained from Table 7.1
parameter Real C= 0.52;
parameter Real m=0.25;

//=============
// Equation Section
equation
//Calculation of film temperature
Tf  = (Tw+ T_infinity)/2;

//Calculation of Coefficient of thermal expansion
beta = 1/(Tf+273);

//Calculation of Rayleigh Equation
Ra = (g*beta * (Tw-T_infinity)*(L*2*0.01)^3*Pr)/(v*v);


//Calculation of Nusselt Number
 Nu= C*((Ra)^(m));

 
//Calculation of heat transfer coefficient
//Note: Multiplication by 0.01 to convert to m 
 Nu= (h_bar*L*2*0.01)/k;
 
  //Calculation of rate of heat transfer rate
 q = h_bar*6*(L*0.01)^2*(Tw-T_infinity);

end Ex7_6;
//===============================================================================
