// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.1 Page 388
// Title: Transmission and Absorption in a Glass Plate
//===================================================================
model Ex8_1
//=============
// Variable Section 
Real A(unit="m^2")"Area of the glass plate";
Real Eb(unit="W/m^2");
Real TIR(unit="W")"Total incident radiation";
Real TRT(unit="kW")"Total radiation transmitted";
Real RA1(unit="W")"Total radiation absorbed between 0 to 3.5 mu_m";
Real RA2(unit="W")"Total radiation absorbed between 3.5 mu_m to infinity";
Real TRA(unit="kW")"Total radiation absorbed";
//=============
// Parameter Section 
parameter Real T(unit="C")=2000"Furnace temperature";
parameter Real L(unit="cm")=30"Side length of glass plate";
parameter Real lamda_1=0.2;
parameter Real lamda_2=3.5;

parameter Real E1=0.3"Emmisivity of glass upto lamda_2";
parameter Real E2=0.9"Emmisivity of glass above lamda_2";

parameter Real sigma(unit="W/m^2.K^4")=5.669E-8"Stefan Boltman constant";

parameter Real t1=0.5"Transmissivity of glass between lamda1 and lamda2";
parameter Real t2=0"Transmissivity of glass except in the range";

//Values from from table 8-1
parameter Real Eb_0_lam1_by_sigmaT4 = 0 ;
parameter Real Eb_0_lam2_by_sigmaT4 = 0.85443 ;

//=============
// Equation Section 
equation
A =(L*1E-2)^2;

Eb =sigma *((T+273)^4);

//Total incident radiation
TIR = Eb*(Eb_0_lam2_by_sigmaT4-Eb_0_lam1_by_sigmaT4)*A;
TRT = (TIR *t1)*1E-3;

//Radiation absorbed
RA1 = E1*TIR ;		
RA2 = E2*(1-Eb_0_lam2_by_sigmaT4)*Eb*A;

TRA =( RA1+RA2)*1E-3;//Calculation of total radiation absorbed

end Ex8_1;
//========================================================================
