// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.20 Page 453
//Title: Solar–Environment Equilibrium Temperatures
//===================================================================
model Ex8_20
//=============
// Variable Section
Real T_1(unit="K");
Real T_2(unit="K");
//=============
// Parameter Section
parameter Real q_by_A_sun(unit="W/m^2") = 700"Solar flux"; 			
parameter Real T_surr(unit="C") = 25"Surrounding temperature"; 			
parameter Real sigma(unit="W/m^2.K^4") = 5.669E-8"Stefan Boltman constant";			
parameter Real alpha_sun = 0.12 ;
parameter Real alpha_low_temp = 0.9;

parameter Real alpha_sun_1 = 0.96 ;
parameter Real alpha_low_temp_1 = 0.95;

//=============
//Equation Section
equation
//Calcultion of radiation conection equilibrium temperature
T_1 = ((q_by_A_sun)*alpha_sun/(alpha_low_temp*sigma)+(T_surr+273)^(4))^(1.0/4.0);
T_2=  ((q_by_A_sun)*alpha_sun_1/(alpha_low_temp_1*sigma)+(T_surr+273)^(4))^(1.0/4.0);

end Ex8_20;
//========================================================================
