// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.8 Page 413
//Title: Open Hemisphere in Large Room
//===================================================================
model Ex8_8
//=============
// Variable Section

Real Eb1(unit="W/m^2");
Real Eb2(unit="W/m^2");
Real A1(unit="m^2")"Area of surface I";
Real A3(unit="m^2")"Area of surface III";
Real R1"Surface Resistance-S1";
Real R3"Surface resistance-S3";

//Shape factors
Real F_12,F_13;
Real q(unit="W")"Radiant heat exchange";

//=============
// Parameter Section
parameter Real d(unit="cm")=30"Diameter of the hemisphere";
parameter Real T1(unit="C")=500"Temperature of the hemisphere";
parameter Real T2(unit="C")=30"Temperature of the enclosure";
parameter Real E =0.4"Surface emmissivity of the hemisphere";
parameter Real sigma(unit="W/m^2.K^4") =5.67E-8"Stefan Boltman constant";
parameter Real R2=0"Surface resistance of II surface";
parameter Real F_31=1"Shape factor between surface 1 and 3";
//=============
// Equation Section
equation
Eb1 = sigma*(T1+273)^4;
Eb2 = sigma*(T2+273)^4;

//Calculation of Surface Area -S1
A1 = (2*3.14*(d*0.01/2)^2);

//Calculation of surface resistance
R1 = (1-E)/(E*A1);
A3 = 3.14*(d*0.01/2)^2;

F_13 = (A3/A1)*F_31;

F_12 = F_13;

R3 = 1/(A1*F_12);

//Calculation of radiant heat exchange
q = (Eb1-Eb2)/(R1+R2+R3);

end Ex8_8;
//========================================================================
