// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.9 Page 415
//Title: Effective Emissivity of Finned Surface
//===================================================================
model Ex8_9
//=============
// Variable Section
Real E_eff_1"Effective Emmsisity for Case-I";
Real E_eff_2"Effective Emmsisity for Case-II";
Real E_eff_3"Effective Emmsisity for Case-III";

Real Ea1"Apparent Emmsisvity for Case-I";
Real Ea2"Apparent Emmsisvity for Case-I";
Real Ea3"Apparent Emmsisvity for Case-I";

//=============
// Parameter Section
parameter Real A1(unit="m^2")=10;
parameter Real A2(unit="m^2")=5;
parameter Real A3(unit="m^2")=60;

parameter Real E_1=0.2"Case:I-Emmisivity combination";
parameter Real E_2=0.5"Case:II-Emmisivity combination";
parameter Real E_3=0.8"Case:III-Emmisivity combination";

//=============
// Equation Section
equation

//Calculation of Effective Emmisivity
Ea1 = (E_1*A3)/(A1+E_1*(A3-A1));
E_eff_1 = ((Ea1*A1+E_1*A2)/(A1+A2));

Ea2 = (E_2*A3)/(A1+E_2*(A3-A1));
E_eff_2 = ((Ea2*A1+E_2*A2)/(A1+A2));

Ea3 = (E_3*A3)/(A1+E_3*(A3-A1));
E_eff_3 = ((Ea3*A1+E_3*A2)/(A1+A2));

end Ex8_9;
//========================================================================
