// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-9:  Condensation and Boiling Heat Transfer
//Example: 9.1 Page 494
//Title: Condensation on Vertical Plate
//===================================================================
model Ex9_1

//=============
// Variable Section 

Real m(unit="kg/s")"Mass Flow rate of Condensate";
Real q(unit="W")"Heat Transfer Rate";
Real Ref"Reynolds Number";
Real h_bar(unit="W/m^2.C")"Heat Transfer Coefficient";
Real T_f(unit="C")"Film Temperature";

//=============
// Parameter Section 
parameter Real T_w(unit="C") =98"Temperature of the plate";
parameter Real T_sat(unit="C") =100"Temperature of steam at atmospheric pressure";
parameter Real L(unit="cm") =30"Length of the plate";

//Properties evaluated at film temperature
parameter Real mu_f(unit="kg/m.s") = 2.82E-4"Viscocity evaluated at film temperature";
parameter Real rho_f(unit="kg/m^3")= 960"Density of condensate film";
parameter Real k_f(unit= "W/m.C") = 0.68"Thermal Conductivity of the film";
parameter Real h_fg(unit="kJ/kg") = 2255"Latent Heat";


//=============
// Equation Section

equation
T_f = (T_w+T_sat)/2;
//Calculation of heat transfer coefficient
h_bar = 0.943 *((rho_f*rho_f*9.81*h_fg*1000*(k_f^3))/(L*0.01*mu_f*(T_sat-T_w)))^(0.25);
//Note:Multiplication of L by 0.01 to convert to m

//Calculation of Reynolds Number
Ref =( 4*h_bar*L*0.01*(T_sat - T_w))/(h_fg*1000*mu_f);

q = h_bar * L*L *0.01*0.01*(T_sat-T_w);
//Note:Multiplication of L by 0.01 to convert to m
//Calculation of mass flow rate of the condensate
m = q /(h_fg*1000);

end Ex9_1;
//===================================================================
