// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-9:  Condensation and Boiling Heat Transfer
//Example: 9.2 Page 495
//Title: Condensation on Tube Bank
//===================================================================
//Note : The below problem is linked to Example 9.1
model Ex9_2

//=============
// Variable Section 
Real m_L(unit="kg/s")"Mass of steam condensed per unit length";
Real q_L(unit="kW/m")"Heat transfer rate per unit length";
Real h_bar(unit="W/m^2.C")"Heat Transfer Coefficient";
Real A_L(unit="m^2/m")"Total surface area";
Real T_f(unit="C")"Film Temperature";

//=============
//Parameter Section
parameter Real d(unit="cm")=1.27"Diameter of the tubes";
parameter Real n=100"Number of tubes";
parameter Real T_w(unit="C")=98"Tube Wall Temperature";
parameter Real T_g(unit="C")=100" Temperature of steam at atmospheric pressure";
//Properties evaluated at film temperature
parameter Real mu_f(unit="kg/m.s") = 2.82E-4"Viscocity evaluated at film temperature";
parameter Real rho_f(unit="kg/m^3")= 960"Density of condensate film";
parameter Real k_f(unit= "W/m.C") = 0.68"Thermal Conductivity of the film";
parameter Real h_fg(unit="kJ/kg") = 2255"Latent Heat";

//=============
//Equation Section
equation

//Calculation of film temperature
T_f = (T_w+T_g)/2;

//Calculation of heat transfer coefficient
h_bar = 0.725 *((rho_f*rho_f*9.81*h_fg*1000*(k_f^3))/(d*10*0.01*mu_f*(T_g-T_w)))^(0.25);
//Note:Multiplication of L by 0.01 to convert to m

//Calculation of total surface area
A_L = n *3.14*d*0.01;
//Note:Multiplication of L by 0.01 to convert to m

//Calculation of Heat Transfer rate
q_L = h_bar *(A_L)*(T_g-T_w)*1E-3;
//Calculation of Mass of Steam condensed per unit length
m_L = (q_L*1000)/(h_fg*1000);

end Ex9_2;
//===================================================================
