// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-9:  Condensation and Boiling Heat Transfer
//Example: 9.4 Page 508
//Title: Flow Boiling
//===================================================================
model Ex9_4
//=============
// Variable Section

Real h(unit="W/m^2.C")"Heat Transfer Coefficient";
Real P_Mpa(unit="Mpa")"Pressure units";
Real A(unit="m^2")"Surface Area";
Real q(unit="W/m")"Heat transfer Rate";

//=============
// Parameter Section

parameter Real P(unit="atm")=5"Pressure at which water flows";
parameter Real d(unit="cm")=2.54"Diameter of the tube";
parameter Real T_w_T_sat(unit="C")=10"Difference between tube wall and saturation temperature";
parameter Real L(unit="m")=1"Length of the tube";

//=============
// Equation Section
equation

//Conversion of Pressure units to Mpa
P_Mpa = P * 1.0132*1E5*1E-6;

h=2.54*(T_w_T_sat)^3*exp(P_Mpa/1.551);
//Calculation of surface area
A = 3.14*d*0.01*L;
//Calculation of heat transfer rate
q = h*A*(T_w_T_sat);


end Ex9_4;
//===================================================================
