// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-9:  Condensation and Boiling Heat Transfer
//Example: 9.5 Page 508
//Title: Water Boiling in a Pan
//===================================================================
model Ex9_5

//=============
// Variable Section
Real h(unit="W/m^2.C")"Heat Transfer Coefficient when nucleate boiling is assumed";
Real q_A(unit="W/m^2")"Heat flux";
Real h_p(unit="W/m^2.C")"Heat transfer coefficient while operation as a pressure cooker";
Real q_A_2(unit="kW/m^2")"Heat flux corresponding to pressure cooker";

//=============
// Parameter Section
parameter Real p1(unit="atm")=1"Pressure at which water boils";
parameter Real p(unit="atm")=0.17"Pressure at which pan operates as a pressure cooker";
parameter Real delta_Tx(unit="C")=8"Difference between tube wall and saturation temperature";

//=============
// Equation Section
equation
//Calculation of heat transfer coefficient when pressure is 1 atm
h = 5.56*(delta_Tx)^3;

q_A = h*delta_Tx;

//Calculation of heat transfer coefficient when pressure is 0.17Mpa
h_p = h*(p/0.101)^0.4;

//Calculation of heat flux corresponding to pressure cooker
q_A_2 = h_p*delta_Tx*0.001;

end Ex9_5;
//===================================================================
