class Ex4_1
  parameter Real M1(unit = "kg") = 10;
  /*Mass of Platform1*/
  parameter Real M2(unit = "kg") = 5;
  /*Mass of Platform2*/
  parameter Real B1(unit = "N.s/m") = 3;
  /*Damping constant*/
  parameter Real B2(unit = "N.s/m") = 3;
  /*Damping constant*/
  parameter Real K1(unit = "N/m") = 5;
  /*Spring constant*/
  parameter Real K2(unit = "N/m") = 5;
  /*Spring constant*/
  Real u(unit = "N") = 10 * sin(5 * time);
  /*Applied force on the platform1*/
  /*the value of the above parameters have been assumed as it is not given in the book.*/
  Real x1(unit = "m");
  /*the displacement of platform1*/
  Real x2(unit = "m");
  /*the displacement of platform2*/
  Real x3(unit = "m/s");
  /*the velocity of platform1*/
  Real x4(unit = "m/s");
  /*the velocity of platform1*/
  Real y1(unit = "m");
  /*output of the system:displacement of platform1*/
  Real y2(unit = "m");
  /*output of the system:displacement of platform2*/
  /*The above parameters and variables are defined to solve the problem using differencial equation.*/
equation
/*Solved the same problem using differencial equation*/
initial equation
  x1 = 0;
  x2 = 0;
  x3 = 0;
  x4 = 0;
/*the above initial conditions have been assumed as it is not given in the book.*/
equation
  der(x1) = x3;
  der(x2) = x4;
  der(x3) = ((-K1 / M1) * x1) + (K1 / M1) * x2 - (B1 / M1) * x3 + (B1 / M1) * x4 + (1 / M1) * u;
  der(x4) = (K1 / M2) * x1 - ((K1 + K2) / M2) * x2 + (B1 / M2) * x3 - ((B1 + B2) / M2) * x4;
  y1 = x1;
  y2 = x2;
  annotation(
    uses(Modelica(version = "3.2.3")));

end Ex4_1;
