class Ex4_4
parameter Real A1(unit="m^2")=10/*cross sectional area of tank1*/;
parameter Real R1(unit="Pa.s/m^3")=0.25/*resistance of the pipe1*/;
parameter Real A2(unit="m^2")=10/*cross sectional area of tank2*/;
parameter Real R2(unit="Pa.s/m^3")=0.15/*resistance of the pipe2*/;
Real u(unit="m^3/s")= 10/*small deviation of the inflow rate from steady-state value*/;
Real x1(unit="m") /*small deviation of the head of the tank1 from its steady-state value*/;
Real x2(unit="m") /*small deviation of the head of the tank2 from its steady-state value*/;
Real y(unit="m^3/s") /*small deviation of the outflow rate of the tank2 from its steady-state value*/;
/*the value of the above parameters have been assumed as it is not given in the book.*/
initial equation
x1=0;
x2=0;
/*the above initial conditions have been assumed as it is not given in the book.*/
equation
der(x1)=-(1/(R1*A1))*x1+(1/(R1*A1))*x2+(1/A1)*u;
der(x2)=(1/(R1*A2))*x1+(-1/(R1*A2)-1/(R2*A2))*x2;
y=(1/R2)*x2;

end Ex4_4;
