class Ex4_6
parameter Real r(unit="time^(-1)")=0.03/*reaction constant*/;
parameter Real Q(unit="volume/time")=10/*inflow rate*/;
parameter Real V(unit="vol")=100/*Volume*/;
parameter Real dH(unit="energy/mole")=5/*Heat liberated by decomposition of one mole of A*/;
parameter Real rho(unit="mass/volume")=0.22/*density of liquid*/;
parameter Real cp(unit="energy/mass-deg")=100/*specific heat of the liquid*/;
Real u1(unit="moles/vol")=5/*concentration of species A in the feed stream*/;
Real u2(unit="energy per second")=10/*heat removal rate*/;
Real x1(unit="moles/vol")/*concentration of A inside the tank*/;
Real x2(deg="deg")/*deviation of temperature inside the liquid*/;
initial equation
x1=0;
x2=0;
/*the above initial conditions have been assumed as it is not given in the book.*/
equation
der(x1)=-(r+(Q/V))*x1+(Q/V)*u1;
der(x2)=((dH*r)/(rho*cp))*x1-(Q/V)*x2-(1/(V*rho*cp))*u2;

end Ex4_6;
