class Ex6_5
parameter Real B2=0.5;/*coefficient*/
parameter Real A[2,2]=[-1,(B2-1)/B2;0,-(1/B2)];/*state matrix*/
parameter Real b[2]={(B2+1)/B2,1/B2};/*input matrix*/
parameter Real U[2,2]=[b,A*b];/*controllability matrix*/
Real q;/*rank of controllability matrix*/
Real x_ana[2];/*state vector for analytical solution*/
Real x[2];/*state vector*/
Real u;/*controller*/

initial equation
x={10,10};

equation
q=Modelica.Math.Matrices.rank(U);

u=0.34*exp(time)-0.068*exp(2*time);

x_ana={0.3967*exp(time)-0.0567*exp(2*time)-0.1473*exp(-time)+9.8073*exp(-2*time),0.2267*exp(time)-0.034*exp(2*time)+9.8073*exp(-2*time)};/*analytical solution*/

der(x)=A*x+b*u;


end Ex6_5;
