class Ex4_2
  parameter Real R1(unit = "ohm") = 9 * 10 ^ 3;
  /*Resistor1*/
  parameter Real R2(unit = "ohm") = 9 * 10 ^ 3;
  /*Resistor2*/
  parameter Real R3(unit = "ohm") = 9 * 10 ^ 3;
  /*Resistor3*/
  parameter Real C1(unit = "F") = 37 * 10 ^ (-6);
  /*Capacitor1*/
  parameter Real C2(unit = "F") = 37 * 10 ^ (-6);
  /*Capacitor2*/
  parameter Real u(unit = "V") = 100;
  /*Constant Voltage Source*/
  /*the value of Constant voltage source(u)has been assumed as it is not given in the book.*/
  Real x1(unit = "V");
  /*Voltage accross the capacitor1*/
  Real x2(unit = "V");
  /*Voltage accross the capacitor2*/
  Real i1(unit = "A");
  /*current through Resistor1*/
  Real i2(unit = "A");
  /*current through Resistor2*/
  Real y[1](unit = "V");
  /*The above parameters and variables are defined to solve the problem using differencial equation. We do not need the above part to solve the problem from diagram view.*/
  Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V = 100) annotation(
    Placement(visible = true, transformation(origin = {-83, 19}, extent = {{-15, -15}, {15, 15}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Capacitor capacitor1(C = 37 * 10 ^ (-6)) annotation(
    Placement(visible = true, transformation(origin = {19, 37}, extent = {{-13, -13}, {13, 13}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Capacitor capacitor2(C = 37 * 10 ^ (-6)) annotation(
    Placement(visible = true, transformation(origin = {79, -13}, extent = {{-13, -13}, {13, 13}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Resistor resistor3(R = 9 * 10 ^ 3) annotation(
    Placement(visible = true, transformation(origin = {80, 36}, extent = {{-14, -14}, {14, 14}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Resistor resistor2(R = 9 * 10 ^ 3) annotation(
    Placement(visible = true, transformation(origin = {18, -14}, extent = {{-14, -14}, {14, 14}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Resistor resistor1(R = 9 * 10 ^ 3) annotation(
    Placement(visible = true, transformation(origin = {-42, 80}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Ground ground annotation(
    Placement(visible = true, transformation(origin = {-71, -87}, extent = {{-13, -13}, {13, 13}}, rotation = 0)));
  Modelica.Electrical.Analog.Interfaces.Pin pin1 annotation(
    Placement(visible = true, transformation(origin = {20, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  /* iconTransformation(origin = {20, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));*/
  /* iconTransformation(origin = {20, -56}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));*/
  Modelica.Electrical.Analog.Interfaces.Pin pin annotation(
    Placement(visible = true, transformation(origin = {18, -52}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {18, -52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(pin, ground.p) annotation(
    Line(points = {{18, -52}, {18, -52}, {18, -64}, {-72, -64}, {-72, -74}, {-70, -74}}, color = {0, 0, 255}));
  connect(capacitor2.n, pin) annotation(
    Line(points = {{80, -26}, {80, -26}, {80, -52}, {18, -52}, {18, -52}}, color = {0, 0, 255}));
  connect(resistor2.n, pin) annotation(
    Line(points = {{18, -28}, {18, -28}, {18, -52}, {18, -52}}, color = {0, 0, 255}));
  connect(constantVoltage.n, pin) annotation(
    Line(points = {{-82, 4}, {-82, 4}, {-82, -52}, {18, -52}, {18, -52}}, color = {0, 0, 255}));
  connect(pin1, capacitor1.p) annotation(
    Line(points = {{20, 80}, {20, 80}, {20, 50}, {20, 50}}, color = {0, 0, 255}));
  connect(pin1, resistor3.p) annotation(
    Line(points = {{20, 80}, {80, 80}, {80, 50}, {80, 50}, {80, 50}}, color = {0, 0, 255}));
  connect(resistor1.n, pin1) annotation(
    Line(points = {{-24, 80}, {18, 80}, {18, 80}, {20, 80}}, color = {0, 0, 255}));
  connect(resistor3.n, capacitor2.p) annotation(
    Line(points = {{80, 22}, {80, 22}, {80, 0}, {80, 0}}, color = {0, 0, 255}));
  connect(capacitor1.n, resistor2.p) annotation(
    Line(points = {{20, 24}, {18, 24}, {18, 0}, {18, 0}}, color = {0, 0, 255}));
  connect(pin1, capacitor1.p) annotation(
    Line(points = {{20, 80}, {20, 80}, {20, 50}, {20, 50}}, color = {0, 0, 255}));
  connect(constantVoltage.p, resistor1.p) annotation(
    Line(points = {{-82, 34}, {-80, 34}, {-80, 80}, {-60, 80}, {-60, 80}}, color = {0, 0, 255}));
/*Solved the same problem using differencial equation*/
initial equation
  x1 = 0;
  x2 = 0;
/*Assuming the above initial condition*/
equation
  R1 * i1 + x1 + R2 * (i1 - i2) - u = 0;
  R3 * i2 + x2 + R2 * (i2 - i1) - x1 = 0;
  der(x1) = (i1 - i2) * (1 / (37 * 10 ^ (-6)));
  der(x2) = i2 * (1 / (37 * 10 ^ (-6)));
  y=[0,1]*{x1,x2};
  annotation(
    uses(Modelica(version = "3.2.3")));

end Ex4_2;
