class Ex4_3
  parameter Real Lf(unit = "H") = 5;
  /*inductance*/
  parameter Real Rf(unit = "ohm")= 10;
  /*resistance*/
  parameter Real Kg = 5;
  /*geberator gain constant*/
  parameter Real Ra(unit = "ohm") = 5;
  /*resistance of armatures*/
  parameter Real Kt = 5;
  /*motor torque constant*/
  parameter Real J(unit="kg.m^2") = 10;
  /*moment of inertia*/
  parameter Real B = 3;
  /*damping constant*/
  parameter Real Kb = 5;
  /*motor back emf constant*/
  parameter Real A = 10;
  /*amplitude of input voltage*/
  parameter Real w(unit="Hz") = 5;
  /*frequency of input voltage*/
  Real u(unit="V") = A * sin(w * time);
  /*input voltage*/
  /*the value of the above parameters have been assumed as it is not given in the book.*/
  Real x1(unit="rad");
  /*angular position of motor*/
  Real x2(unit="rad/s");
  /*angular velocity of motor*/
  Real x3(unit="A");
  /*generator field current*/
  /*The above parameters and variables are defined to solve the problem using differencial equation.*/
equation
/*Solved the same problem using differencial equation*/
initial equation
  x1 = 0;
  x2 = 0;
  x3 = 0;
/*the above initial conditions have been assumed as it is not given in the book.*/
equation
  der(x1) = x2;
  der(x2) = (-(B / J + (Kt * Kb )/ (J * Ra)) * x2) + ((Kt * Kg )/ (J * Ra)) * x3;
  der(x3) = ((-Rf / Lf) * x3) + (1 / Lf) * u;
  annotation(
    uses(Modelica(version = "3.2.3")),
    Diagram);

end Ex4_3;
