class Ex4_5
parameter Real Cf(unit="J/K")=0.25/*thermal capacitance of the tank body*/;
parameter Real Ct(unit="J/K")=0.25/*thermal capacitance of fluid in the tank*/;
parameter Real e0(unit="V")=10/*input voltage corresponding to steady-state of the system*/;
parameter Real R(unit="ohm")=5/*resistance of heater element*/;
parameter Real J=100/*Joules constant*/;
parameter Real RCV(unit="K/W")=0.5/*convective thermal resistance*/;
parameter Real RCD(unit="K/W")=0.4/*conducctive thermal resistance*/;
Real u(unit="V")=0.5/*deviation of input voltage*/;
/*the value of the above parameters have been assumed as it is not given in the book.*/
Real x1(unit="K")/*deviation of fluid temperature from its steady-state value*/;
Real x2(unit="K")/*deviation of tank-body temperature from its steady-state value*/;
initial equation
x1=0;
x2=0;
/*the above initial conditions have been assumed as it is not given in the book.*/
equation
der(x1)=-(1/(Cf*(RCV+RCD)))*x1+(1/(Cf*(RCV+RCD)))*x2+((2*e0)/(Cf*R*J))*u;
der(x2)=(1/(Ct*(RCV+RCD)))*x1-(1/(Ct*(RCV+RCD)))*x2;

end Ex4_5;
