class Ex5_16
Real k;
parameter Real F[2,2] =[0,1;-1,-2];/*state matrix*/
Real x_ana[2];/*state vector for analytical solution*/
Real x0_ana[2]={2,2};/*initial value of x_ana-assuming*/
Real z[2];
Real z0[2];

Real x[2];/*state vector*/

parameter Real DT=0.2;/*sample period*/
Real E[2,2];/*eigenvaue*/
Real M[2,2]=[1,0;-1,1];/*Modal matrix*/

equation
E = Modelica.Math.Matrices.eigenValues(F);
z0=Modelica.Math.Matrices.inv(M)*x0_ana;

initial equation
z=z0;
x_ana=x0_ana;
x={2,2};/*initial value of x-assuming*/

equation
when sample(0.2,DT)then
k=time/DT;
z=[(E[1,1])^k,k*(E[1,1])^(k-1);0,(E[1,1])^k]*z0;
x_ana=M*z;
x=F*pre(x);/*solution from discrete equation of state*/
end when;


end Ex5_16;
