class Ex11_6
parameter Real DT=0.2;/*sampling interval*/
Real F[2,2]=[0.9512,0;0,0.9048];/*state matrix*/
Real G[2,2]=[4.88,4.88;-0.019,0.0095];/*input matrix*/
Real Q[2,2]=[0.01,0;0,100];
Real R[2,2]=[2,0;0,0.5];
Real P[2,2];
Real K[2,2];/*gain matrix*/
Real u[2];/*optimal controller*/
Real x[2];/*sate vector*/
Real k;
equation
K=-Modelica.Math.Matrices.inv(R+transpose(G)*P*G)*transpose(G)*P*F;
P=transpose(F+G*K)*P*[F+G*K]+transpose(K)*R*K+Q;
initial equation
x={2,1};
u=K*{2,1};
equation
when sample(0,DT)then
k=time/DT;
if k<=0 then
x={2,1};
u=K*{2,1};
else
u=K*x;
x=F*pre(x)+G*pre(u);
end if;
end when;

end Ex11_6;
