class Ex10_2
parameter Real pi = Modelica.Constants.pi;

parameter Real d(unit="in")=1/4;/*diameter of the rod*/
Real A(unit="in^2");/*cross sectional area of the rod*/
parameter Real F(unit="lb")=2500;/*tensile load on the rod*/
Real sigma(unit="lb/in^2");/*tensile stress*/
parameter Real sigma_tu(unit="lb/in^2")=61000;/*ultimate tensile stress*/
parameter Real sigma_ty(unit="lb/in^2")=45000;/*yield tensile stress*/

algorithm
A:=(pi*d^2)/4;
sigma:=F/A;
if sigma>=sigma_ty and sigma<=sigma_tu then
Modelica.Utilities.Streams.print("The rod will experience a permanent set, but it will not fracture");
 else
Modelica.Utilities.Streams.print("The rod will experience a permanent set");
end if;
/*The print message will show up in the simulation output window and not in Messages Browser*/ 

/*The  answer may slightly vary due to  rounding off values*/
end Ex10_2;
