class Ex2_2
/*Pressure- 1 atm=2116 lb/ft^2*/
/*Mass- 1 slug=32.2 lbm*/
parameter Real V(unit="ft^3")=1000;/*Volume of Tunnel*/
parameter Real p_s(unit="atm")=30;/*Standard pressure*/
parameter Real T(unit="degR")=530;/*Teamperature*/
parameter Real p(unit="lb/ft^2")=p_s*2116;/*pressure in fps system*/
parameter Real R(unit="(ft.lb)/(slug.degR)")=1716;/*Specific Gas Constant of Air*/
Real rho(unit="slug/ft^3");/*Density of air in the tank*/
Real M_s(unit="slugs");/*Mass of air in the tank in slugs(unit)*/
Real M_lbm(unit="lbm");/*Mass of air in the tank in lbm(unit)*/
equation
p=rho*R*T;
M_s=rho*V;
M_lbm=M_s*32.2;
end Ex2_2;
