class Ex2_3
/*Pressure- 1 atm=1.01*10^5 N/m^2*/
parameter Real p_atm(unit="atm")=0.3;/*pressure in atm unit*/
Real p(unit="N/m^2");/*pressure in SI unit*/
parameter Real T_degC(unit="degC")=-100;/*Temperature in degree Celcius*/
Real T(unit="K");/*Temperature in Kelvin*/
parameter Real R(unit="J/(kg.K)")=287;/*Specific Gas Constant of Air*/
Real rho(unit="kg/m^3");/*air density*/
Real v(unit="m^3/kg");/*specific volume*/
equation
p=p_atm*1.01*10^5;
T=Modelica.SIunits.Conversions.from_degC(T_degC);
p=rho*R*T;
v=1/rho;
end Ex2_3;
