class Ex4_11
/*Vlocity- 60 mi/h=88 ft/s */
parameter Real T_infinite(unit="degR")=411.86;/*Air temperature at 30000 ft*/
parameter Real V_infinite(unit="mi/h")=550;/*velocity of jet*/
Real V_infinite_fps(unit="ft/s");/*velocity of jet in fps system*/
Real a_infinite(unit="ft/s");/*speed of sound*/
Real M_infinite;/*Mach number*/

parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="ft.lb/(slug.degR)")=1716;/*Specific Gas Constant of Air*/

equation
a_infinite=sqrt(gama*R*T_infinite);
V_infinite_fps=V_infinite*(88/60);
M_infinite=V_infinite_fps/a_infinite;
end Ex4_11;
