class Ex4_13
/*pressure 1 atm=1.01*10^5 N/m^2;*/
parameter Real g(unit="m/s^2")=9.8;/*acceleration due to gravity*/ 
parameter Real R(unit="J/kg*K")=287;/*Specific Gas Constant of Air*/

parameter Real A_contraction_ratio=1/15;/*(A1/A2)-contraction ratio*/

parameter Real p_1(unit="atm")=1.1;/*pressure at reservior*/
Real p_1_SI(unit="N/m^2");/*pressure at reservior in SI Units*/

parameter Real T_1(unit="K")=300;/*temperature at reservior*/

parameter Real rho_l(unit="kg/m^3")=1.36*10^4;/*density of mercury*/

parameter Real del_h(unit="cm")=10;/*the height difference between two column of mercury*/
Real del_h_m(unit="m");/*the height difference between two column of mercury in meter*/

Real w(unit="N/m^3");/*specific weight of mercury*/
Real p1_p2(unit="N/m^2");/*pressure difference*/

Real rho_1(unit="kg/m^3");/*density of air at reservior*/ 
Real rho(unit="kg/m^3");/*density of air at tunnel*/

Real V_2(unit="m/s");/*airflow velocity at the test section*/

equation
del_h_m=del_h/100;
p_1_SI=p_1*1.01*10^5;
w=rho_l*g;
p1_p2=w*del_h_m;
rho_1=p_1_SI/(R*T_1);
rho=rho_1;
V_2=sqrt((2*p1_p2)/(rho*(1-A_contraction_ratio^2)));
end Ex4_13;
