class Ex4_14
/*pressure 1 atm=1.01*10^5 N/m^2;*/
parameter Real A_1(unit="m^2")=2;/*cross section area of reservior*/
parameter Real A_2(unit="m^2")=0.5;/*cross section area of test section*/

parameter Real p_2(unit="atm")=1;/*pressure at test section*/
Real p_2_SI(unit="N/m^2");/*pressure at test section in SI Units*/

Real V_1(unit="m/s");/*airflow velocity at the reservior*/
parameter Real V_2(unit="m/s")=40;/*airflow velocity at the test section*/

parameter Real rho(unit="kg/m^3")=1.23;/*density of air at tunnel*/

Real p_1(unit="N/m^2");/*pressure at test section*/
Real m_dot(unit="kg/s");/*mass flow through the wind tunnel*/

equation 
/*Number-a*/
p_2_SI=p_2*1.01*10^5;
A_1*V_1=A_2*V_2;
p_1+(rho*V_1^2)/2=p_2_SI+(rho*V_2^2)/2;

/*Number-b*/
m_dot=rho*A_1*V_1;

end Ex4_14;
