class Ex4_26
parameter Real x_1(unit="cm")=1;/*length of plate at 1 cm*/
Real x_1_SI(unit="m");/*length of plate plate at point 1 in SI units*/
parameter Real x_5(unit="cm")=5;/*length of plate plate at 5 cm*/
Real x_5_SI(unit="m");/*length of plate plate at 5 cm in SI units*/

parameter Real V_infinite(unit="m/s")=120;/*freestream velocity*/
parameter Real rho_infinite(unit="kg/m^3")=1.225;/*freestream density*/
parameter Real mu_infinite(unit="kg/m.s")=1.789*10^(-5);/*viscosity of freestream*/

Real Re_x_1;/*Reynolds Number at 1 cm*/
Real Re_x_5;/*Reynolds Number at 5 cm*/

Real C_fx_1;/*skin friction drag coefficient at 1cm*/
Real C_fx_5;/*skin friction drag coefficient at 5 cm*/

Real tau_w_1(unit="N/m^2");/*local shear stress at 1cm*/ 
Real tau_w_5(unit="N/m^2");/*local shear stress at 5cm*/ 

Real q_infinite(unit="N/m^2");/*dynamics pressure*/

equation
q_infinite=(1/2)*rho_infinite*V_infinite^2;

x_1_SI=x_1/100;
Re_x_1=(rho_infinite*V_infinite*x_1_SI)/mu_infinite;
C_fx_1=0.0592/Re_x_1^0.2;
tau_w_1=q_infinite*C_fx_1;

x_5_SI=x_5/100;
Re_x_5=(rho_infinite*V_infinite*x_5_SI)/mu_infinite;
C_fx_5=0.0592/Re_x_5^0.2;
tau_w_5=q_infinite*C_fx_5;


end Ex4_26;
