class Ex5_1
parameter Real V_infinite(unit="m/s")=50;/*flow velocity in the test section*/
parameter Real rho_infinite(unit="kg/m^3")=1.225;/*density  flow in the test section*/
parameter Real mu_infinite(unit="kg/m.s")=1.789*10^(-5);/*viscosity of flow*/

parameter Real c(unit="m")=1.3;/*cord length of airfoil*/
parameter Real s_w(unit="m")=1;/*span of wing*/
Real S(unit="m^2");/*area of wing*/

Real c_l;/*lift coefficient of airfoil*/
Real c_m_c_4;/*moment coefficien tabout quarter cord point of airfoil*/
Real Re;/*Reynolds number*/
Real c_d;/*drag coefficient of airfoil*/

Real q_infinite(unit="N/m^2");/*dynamics pressure*/
Real L(unit="N");/*lift*/
Real D(unit="N");/*drag*/
Real M_c_4(unit="N.m");/*moment about the quarter cord point*/
equation
/*Number-a*/
c_l=0.63;
c_m_c_4=-0.035;
Re=(rho_infinite*V_infinite*c)/mu_infinite;
c_d=0.007;

/*Number-b*/
S=c*s_w;
q_infinite=(1/2)*rho_infinite*V_infinite^2;

L=q_infinite*S*c_l;
D=q_infinite*S*c_d;
M_c_4=q_infinite*S*c_m_c_4*c;
end Ex5_1;
