class Ex5_11
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="ft.lb/(slug.degR)")=1716;/*Specific Gas Constant of Air*/

parameter Real alpha_deg(unit="deg")=5;/*angle of attack of the airfoil in degree*/
Real alpha(unit="rad");/*angle of attack of the airfoil in radian*/
parameter Real c(unit="ft")=5;/*chord length of the airfoil*/

parameter Real rho_infinite(unit="slug/ft^3")=1.2673*10^(-3);/*atmospheric density at 20000 ft*/
parameter Real T_infinite(unit="degR")=447.43;/*atmospheric temperature at 20000 ft*/
Real a_infinite(unit="ft/s");/*speed of sound*/

parameter Real M_infinite1=3;/*free stream Mach number for 1st condition*/
Real V_infinite1(unit="ft/s");/*free stream velocity for Mach=3*/
Real q_infinite1(unit="lb/ft^2");/*dynamics pressure for Mach=3*/
Real c_l_1;/*lift coefficient for Mach=3*/
Real c_dw1;/*wave drag coefficient for Mach=3*/
Real L_1(unit="lb");/*lift per unit span  for Mach=3*/
Real D_w1(unit="lb");/*wave drag per unit span for Mach=3*/

parameter Real M_infinite2=2;/*free stream Mach number for 2nd condition*/
Real V_infinite2(unit="ft/s");/*free stream velocity for Mach=2*/
Real q_infinite2(unit="lb/ft^2");/*dynamics pressure for Mach=2*/
Real c_l_2;/*lift coefficient for Mach=2*/
Real c_dw2;/*wave drag coefficient for Mach=2*/
Real L_2(unit="lb");/*lift per unit span  for Mach=2*/
Real D_w2(unit="lb");/*wave drag per unit span for Mach=2*/

equation
/*Number-a*/
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
a_infinite=sqrt(gama*R*T_infinite);

/*for Mach=3*/
c_l_1=4*alpha/sqrt(M_infinite1^2-1);
c_dw1=4*alpha^2/sqrt(M_infinite1^2-1);

V_infinite1=a_infinite*M_infinite1;
q_infinite1=(1/2)*rho_infinite*V_infinite1^2;
L_1=q_infinite1*c*c_l_1;
D_w1=q_infinite1*c*c_dw1;

/*Number-b*/

/*for Mach=2*/
c_l_2=4*alpha/sqrt(M_infinite2^2-1);
c_dw2=4*alpha^2/sqrt(M_infinite2^2-1);

V_infinite2=a_infinite*M_infinite2;
q_infinite2=(1/2)*rho_infinite*V_infinite2^2;
L_2=q_infinite2*c*c_l_2;
D_w2=q_infinite2*c*c_dw2;

/*The  answer may slightly vary due to  rounding off values*/
end Ex5_11;
