class Ex5_15
/*velocity- 60 mi/h=88 ft/s;*/
parameter Real pi = Modelica.Constants.pi;
parameter Real e =0.8;/*span efficiency factor*/
parameter Real L(unit="lb")=18000;/*lift of aircraft*/
parameter Real S(unit="ft^2")=170;/*wing planform area*/
parameter Real b(unit="ft")=25.25;/*wingspan of the aircraft*/
Real AR;/*aspect ratio of the aircraft*/

parameter Real V_infinite(unit="mi/h")=250;/*flight velocity of aircraft*/
Real V_infinite_fps(unit="ft/s");/*flight velocity of aircraft in fps system*/

parameter Real rho_infinite(unit="lb/ft^3")=0.002377;/* atmospheric density*/
Real q_infinite(unit="lb/ft^2");/*dynamics pressure*/

Real C_L;/*lift coefficient*/
Real C_Di;/*induced drag coefficient*/
Real D_i(unit="lb");/*induced drag*/

equation
V_infinite_fps=V_infinite*(88/60);
q_infinite=(1/2)*rho_infinite*V_infinite_fps^2;
C_L=L/(q_infinite*S);
AR=b^2/S;
C_Di=C_L^2/(pi*e*AR);
D_i=q_infinite*S*C_Di;

end Ex5_15;
